﻿####procedure of experiment4: 
####0.before the experiment, participants are shown a video, knife cut video, to eliminate the SCR rising as participants first see a knife.
####1.participants come, sit down, wear the glove, SCR electrode. run SCR, run experiment, pre-experiment proprioceptive drift is measured
####2.participants experience the glove, see the movement of the virtual hand and feel the vibration, this is the illusion part, past-experiment proprioceptive drift is measured
####2.1.in the illusion part, the glove could be -virtual hand(H) or -virtual square(S), 
####2.2.the virtual hand/square could be actively moved(A) or passively stable(P).
####2.3.people feel the vibration when the ball touches the hand/square
####3.participants experience the sharp knife(E), SCR is measured
####4.HOW TO MEASURE TEMPERATURE??????

####experiment 4 comparison is designed as:
import viz
import vizact
import vizcam
import viztask
import vizinfo
import vizinput
import vizmat
import numpy
from numpy import binary_repr
#
########################################## add models #####################################
#### Debugging variable to speed up the experiment (the video sequence is only played, if debugging is set to 1)
debugging = 1

####this part of code is for Biopac, when participant press button r to start experience the needle or knife, vizard will send a pulse to Biopac.
####Function sendPulse is for markers, here we need markers: 
####1. the start and end of every block, which also is the onset and end of anmation, for 4 times, d = [0,1,0,0,0,0,0,0], markernumber = 1
####2. in ball block, the onset of the ball touch palm animation, for 4 times, d = [0,0,1,0,0,0,0,0], markernumber = 2
####3. in knife block, the onset of the knife touch palm animation, for 4 times, d = [0,0,0,1,0,0,0,0], markernumber = 2
####here we should use channel 15(d = 128) and channel 14(d = 64).
import vizparallel
port = 0x0378	####if changed, remember to change the port number (this is the port through which the markers are sent)
value = vizparallel.read(port)

def sendPulse(markernumber):
	####here markernumber has four possibilities, they are 1,2
	d = [int(x) for x in binary_repr(markernumber, width=8)]
	value = 128*d[0] + 64*d[1] + 32*d[2] + 16*d[3] + 8*d[4] + 4*d[5] + 2*d[6] + 1*d[7]
	vizparallel.write(value, port)
	vizact.ontimer2(1, 0, vizparallel.write, 0, port)

####this part is for intersense
isense = viz.add('intersense.dle')
tracker = isense.addTracker(port=9) ####if changed, remember to change the port number
vizact.onkeydown (' ', tracker.reset)

#####this part is for hand module imported
immersion = viz.add('immersion.dle')
glovecyber = immersion.addCyberTouch(port=1, baudRate=115200)

####virtual square and designed action: size or color? I prefer color......fadeto is for color, here from [0,0,1](blue) to [0,1,0](green)
sizeofx = 0.0027;	sizeofy = 0.0027; 	sizeofz = 0.0027; 	latencytime = 0;
colorpanel_action0 = vizact.sizeTo([sizeofx*0.5,sizeofy*0.5,sizeofz*0.5],time=latencytime)
colorpanel_action1 = vizact.sizeTo([sizeofx*0.5,sizeofy*0.5,sizeofz*0.5],time=latencytime)
colorpanel_action2 = vizact.sizeTo([sizeofx*0.6,sizeofy*0.6,sizeofz*0.6],time=latencytime)
colorpanel_action3 = vizact.sizeTo([sizeofx*0.6,sizeofy*0.6,sizeofz*0.6],time=latencytime)
colorpanel_action4 = vizact.sizeTo([sizeofx*0.7,sizeofy*0.7,sizeofz*0.7],time=latencytime)
colorpanel_action5 = vizact.sizeTo([sizeofx*0.7,sizeofy*0.7,sizeofz*0.7],time=latencytime)
colorpanel_action6 = vizact.sizeTo([sizeofx*0.8,sizeofy*0.8,sizeofz*0.8],time=latencytime)
colorpanel_action7 = vizact.sizeTo([sizeofx*0.8,sizeofy*0.8,sizeofz*0.8],time=latencytime)
colorpanel_action8 = vizact.sizeTo([sizeofx*0.9,sizeofy*0.9,sizeofz*0.9],time=latencytime)
colorpanel_action9 = vizact.sizeTo([sizeofx*1,sizeofy*1,sizeofz*1],time=latencytime)

import vizfx.postprocess
from vizfx.postprocess.color import ContrastEffect
effect = ContrastEffect(0.3)
vizfx.postprocess.addEffect(effect) 

#### proprioceptive drift measurement design
driftnumber = ['AaBbCcDd','EeFfGg','HhIiJjKk','LlMmNn','OoPpQq','RrSsTt','UuVvWw','XxYyZz']
driftnumber_condition1 = driftnumber[0]+driftnumber[1]+driftnumber[2]+driftnumber[3]+driftnumber[4]+driftnumber[5]+driftnumber[6]+driftnumber[7]		####for condition 1
driftnumber_condition2 = driftnumber[1]+driftnumber[2]+driftnumber[3]+driftnumber[4]+driftnumber[5]+driftnumber[6]+driftnumber[7]+driftnumber[0]		####for condition 2
driftnumber_condition3 = driftnumber[2]+driftnumber[3]+driftnumber[4]+driftnumber[5]+driftnumber[6]+driftnumber[7]+driftnumber[0]+driftnumber[1]		####for condition 3
driftnumber_condition4 = driftnumber[3]+driftnumber[4]+driftnumber[5]+driftnumber[6]+driftnumber[7]+driftnumber[0]+driftnumber[1]+driftnumber[2]		####for condition 4
driftnumber_condition5 = driftnumber[4]+driftnumber[5]+driftnumber[6]+driftnumber[7]+driftnumber[0]+driftnumber[1]+driftnumber[2]+driftnumber[3]		####for condition 5
driftnumber_condition6 = driftnumber[5]+driftnumber[6]+driftnumber[7]+driftnumber[0]+driftnumber[1]+driftnumber[2]+driftnumber[3]+driftnumber[4]		####for condition 6
driftnumber_condition7 = driftnumber[6]+driftnumber[7]+driftnumber[0]+driftnumber[1]+driftnumber[2]+driftnumber[3]+driftnumber[4]+driftnumber[5]		####for condition 7
driftnumber_condition8 = driftnumber[7]+driftnumber[0]+driftnumber[1]+driftnumber[2]+driftnumber[3]+driftnumber[4]+driftnumber[5]+driftnumber[6]		####for condition 8

#### Definition of the questions and the question-instructions
questions4handpassive = ['Sometimes I felt as if the hand on the' + '\n' + 'screen were my right hand or part of my body',
									 'Sometimes it seemed as if what I were' + '\n' + 'feeling on my right hand was caused by the touch of the\nblue stick on the hand on the screen that I was seeing',
									 'Sometimes I had the sensation that the' + '\n' + 'vibration I felt on my right hand was on the same location'+ '\n' + 'where the hand on the screen was\ntouched by the blue stick',
									 'It sometimes seemed my right hand was' + '\n' + 'in the location where the hand on the screen was',
									 'It seemed like I could not really tell where\nmy right hand was',
									 'It no longer felt like my right hand\nbelonged to my body',			 
									 'It seemed as if I might have a third' + '\n' + 'hand besides my left and right hands',
									 'I felt vibration on both my right hand and\nthe hand on the screen at the same time',
									 'Sometimes I felt as if my right hand were' + '\n' + 'turning virtual',
									 'The hand on the screen began to' + '\n' + 'resemble my right hand, in terms of shape, skin tone,' + '\n' + 'or some other visual feature',
									 'It appeared (visually) as if the hand on\nthe screen were drifting towards my right hand',
									 'It seemed like I could have moved the hand on\nthe screen if I had wanted, as if it were obeying my will',
									 'I felt as if my right hand grew longer']

questions4squarepassive = ['Sometimes I felt as if the square on the' + '\n' + 'screen were my right hand or part of my body',
										 'Sometimes it seemed as if what I were' + '\n' + 'feeling was caused by the touch of the\nblue stick on the square on the screen that I was seeing',
										 'Sometimes I had the sensation that the' + '\n' + 'vibration I felt on my right hand was on the same location'+ '\n' + 'where the square on the screen was\ntouched by the blue stick',
										 'It sometimes seemed my right hand was' + '\n' + 'in the location where the square on the screen was',
										 'It seemed like I could not really tell where\nmy right hand was',
										 'It no longer felt like my right hand\nbelonged to my body',
										 'It seemed as if I might have a square-like' + '\n' + 'hand besides my left and right hands',
										 'I felt vibration on both my right hand and\nthe square at the same time',
										 'Sometimes I felt as if my right hand were' + '\n' + 'turning virtual',
										 'The square on the screen began to' + '\n' + 'resemble my right hand, in terms of shape, skin tone,' + '\n' + 'or some other visual feature',
										 'It appeared (visually) as if the square were\ndrifting towards my right hand',
										 'It seemed like I could have moved the square\nif I had wanted, as if it were obeying my will',
										 'I felt as if my right hand grew longer']

questions4handactive = ['Sometimes I felt as if the hand on the' + '\n' + 'screen were my right hand or part of my body',
									 'Sometimes it seemed as if what I were' + '\n' + 'feeling on my right hand was caused by the touch of the\nblue stick on the hand on the screen that I was seeing',
									 'Sometimes I had the sensation that the' + '\n' + 'vibration I felt on my right hand was on the same location'+ '\n' + 'where the hand on the screen was\ntouched by the blue stick',
									 'It sometimes seemed my right hand was' + '\n' + 'in the location where the hand on the screen was',
									 'It seemed like I could not really tell where\nmy right hand was',
									 'It no longer felt like my right hand\nbelonged to my body',			 
									 'It seemed as if I might have a third' + '\n' + 'hand besides my left and right hands',
									 'I felt vibration on both my right hand and\nthe hand on the screen at the same time',
									 'Sometimes I felt as if my right hand were' + '\n' + 'turning virtual',
									 'The hand on the screen began to' + '\n' + 'resemble my right hand, in terms of shape, skin tone,' + '\n' + 'or some other visual feature',
									 'It appeared (visually) as if the hand on\nthe screen were drifting towards my right hand',
									 'The movements of the hand on the screen' + '\n' + 'were caused by myself',
									 'I felt as if my right hand grew longer']

questions4squareactive = ['Sometimes I felt as if the square on the' + '\n' + 'screen were my right hand or part of my body',
										'Sometimes it seemed as if what I was' + '\n' + 'feeling were caused by the touch of the\nblue stick on the square on the screen that I was seeing',
										'Sometimes I had the sensation that the' + '\n' + 'vibration I felt on my right hand was on the same location'+ '\n' + 'where the square on the screen was\ntouched by the blue stick',
										'It sometimes seemed my right hand was' + '\n' + 'in the location where the square on the screen was',
										'It seemed like I could not really tell where\nmy right hand was',
										'It no longer felt like my right hand\nbelonged to my body',
										'It seemed as if I might have a square-like' + '\n' + 'hand besides my left and right hands',
										'I felt vibration on both my right hand and\nthe square at the same time',
										'Sometimes I felt as if my right hand were' + '\n' + 'turning virtual',
										'The square on the screen began to' + '\n' + 'resemble my right hand, in terms of shape, skin tone,' + '\n' + 'or some other visual feature',
										'It appeared (visually) as if the square were\ndrifting towards my right hand',
										'The movements of the square on the screen' + '\n' + 'were caused by myself',
										'It seems that the square-size changes has a\nrelationship with the felt vibration',
										'I felt as if my right hand grew longer']

questions4hand_condition1 = [questions4handpassive[0],questions4handpassive[1],questions4handpassive[2],questions4handpassive[3],questions4handpassive[4],questions4handpassive[5],questions4handpassive[6],questions4handpassive[7],questions4handpassive[8],questions4handpassive[9],questions4handpassive[10],questions4handpassive[11],questions4handpassive[12]]		####for condition 1		 ----passive, no question 1
questions4hand_condition2 = [questions4handpassive[12],questions4handpassive[11],questions4handpassive[10],questions4handpassive[9],questions4handpassive[8],questions4handpassive[7],questions4handpassive[6],questions4handpassive[5],questions4handpassive[4],questions4handpassive[3],questions4handpassive[2],questions4handpassive[1],questions4handpassive[0]]		####for condition 2		 ----passive, no question 1

questions4hand_condition3 = [questions4handactive[0],questions4handactive[1],questions4handactive[2],questions4handactive[3],questions4handactive[4],questions4handactive[5],questions4handactive[6],questions4handactive[7],questions4handactive[8],questions4handactive[9],questions4handactive[10],questions4handactive[11],questions4handactive[12]]		####for condition 1		 ----passive, no question 1
questions4hand_condition4 = [questions4handactive[12],questions4handactive[11],questions4handactive[10],questions4handactive[9],questions4handactive[8],questions4handactive[7],questions4handactive[6],questions4handactive[5],questions4handactive[4],questions4handactive[3],questions4handactive[2],questions4handactive[1],questions4handactive[0]]		####for condition 2		 ----passive, no question 1

questions4hand_condition5 = [questions4squarepassive[0],questions4squarepassive[1],questions4squarepassive[2],questions4squarepassive[3],questions4squarepassive[4],questions4squarepassive[5],questions4squarepassive[6],questions4squarepassive[7],questions4squarepassive[8],questions4squarepassive[9],questions4squarepassive[10],questions4squarepassive[11],questions4squarepassive[12]]		####for condition 1		 ----passive, no question 1
questions4hand_condition6 = [questions4squarepassive[12],questions4squarepassive[11],questions4squarepassive[10],questions4squarepassive[9],questions4squarepassive[8],questions4squarepassive[7],questions4squarepassive[6],questions4squarepassive[5],questions4squarepassive[4],questions4squarepassive[3],questions4squarepassive[2],questions4squarepassive[1],questions4squarepassive[0]]		####for condition 2		 ----passive, no question 1

questions4hand_condition7 = [questions4squareactive[0],questions4squareactive[1],questions4squareactive[2],questions4squareactive[3],questions4squareactive[4],questions4squareactive[5],questions4squareactive[6],questions4squareactive[7],questions4squareactive[8],questions4squareactive[9],questions4squareactive[10],questions4squareactive[11],questions4squareactive[12],questions4squareactive[13]]		####for condition 1		 ----passive, no question 1
questions4hand_condition8 = [questions4squareactive[13],questions4squareactive[12],questions4squareactive[11],questions4squareactive[10],questions4squareactive[9],questions4squareactive[8],questions4squareactive[7],questions4squareactive[6],questions4squareactive[5],questions4squareactive[4],questions4squareactive[3],questions4squareactive[2],questions4squareactive[1],questions4squareactive[0]]		####for condition 2		 ----passive, no question 1

qinstructions = '\n' + 'Please select a number between 1 and 7' + '\n' + '1 means you do not agree and 7 means you agree'

#### similarity:0-virtual hand(H);1-virtual sqaure(S);			passiveoractive:0-passive(P);1-active(A);	 	synchronicity:0-sync(S);1-async(AS);		event:knife(E);
similaritys_1 = [0,1];					similaritys_2 = [1,0];						####
passiveoractives_1 = [0,1];			passiveoractives_2 = [1,0];				####
synchronicitys_1 = [0,1];			synchronicitys_2 = [1,0];				####

totalblocknumber = 8
subjectnumber = vizinput.input('What is your subject number?');		subjectnumber = int(subjectnumber)
#subjectnumber = 1;

if subjectnumber%8 == 1:
	similaritys = similaritys_1;	passiveoractives = passiveoractives_1;	synchronicitys = synchronicitys_1;		driftnumberused_1 = driftnumber_condition1;		driftnumberused_2 = driftnumber_condition8;
if subjectnumber%8 == 2:
	similaritys = similaritys_1;	passiveoractives = passiveoractives_1;	synchronicitys = synchronicitys_2;		driftnumberused_1 = driftnumber_condition2;		driftnumberused_2 = driftnumber_condition7;
if subjectnumber%8 == 3:
	similaritys = similaritys_1;	passiveoractives = passiveoractives_2;	synchronicitys = synchronicitys_1;		driftnumberused_1 = driftnumber_condition3;		driftnumberused_2 = driftnumber_condition6;
if subjectnumber%8 == 4:
	similaritys = similaritys_1;	passiveoractives = passiveoractives_2;	synchronicitys = synchronicitys_2;		driftnumberused_1 = driftnumber_condition4;		driftnumberused_2 = driftnumber_condition5;
if subjectnumber%8 == 5:
	similaritys = similaritys_2;	passiveoractives = passiveoractives_1;	synchronicitys = synchronicitys_1;		driftnumberused_1 = driftnumber_condition5;		driftnumberused_2 = driftnumber_condition4;
if subjectnumber%8 == 6:
	similaritys = similaritys_2;	passiveoractives = passiveoractives_1;	synchronicitys = synchronicitys_2;		driftnumberused_1 = driftnumber_condition6;		driftnumberused_2 = driftnumber_condition3;
if subjectnumber%8 == 7:
	similaritys = similaritys_2;	passiveoractives = passiveoractives_2;	synchronicitys = synchronicitys_1;		driftnumberused_1 = driftnumber_condition7;		driftnumberused_2 = driftnumber_condition2;
if subjectnumber%8 == 0:
	similaritys = similaritys_2;	passiveoractives = passiveoractives_2;	synchronicitys = synchronicitys_2;		driftnumberused_1 = driftnumber_condition8;		driftnumberused_2 = driftnumber_condition1;

#### Preparing the subject's logging file
file = open('response ' +str(subjectnumber)+ '.txt', 'w');		
file.write('PP\tsim\tpa\tsync\tq1\tq2\tq3\tq4\tq5\tq6\tq7\tq8\tq9\tq10\tq11\tq12\tq13\tq14\n');		
file.close()

#### Defining the instructions
text_dict = {}
for kind in ['instructions']:
	text = viz.addText('', viz.SCREEN );			
	text.setScale( .4,.4);			
	text.alignment( viz.TEXT_LEFT_TOP );
	text_dict[ kind ] = text
text_dict['instructions'].setPosition( 0.07,0.87 )

####################################### START ###########################################
viz.setMultiSample(4);		
viz.fov(60);		
viz.go(viz.FULLSCREEN);		viz.mouse( viz.OFF );
#viz.go()
screen = viz.addTexQuad(pos=[0, -0.6, 0.1], scale = [0.57, 0.8, 2], euler = [0,70,0]);			screen.alpha(0)

######################################## Tasks ######################################
def instructions():
	text = text_dict[ 'instructions' ]
	text.message('In the following task, you will try the data-glove.')	
	yield viztask.waitTime( 2 )
	text.message('Please wear the glove and tracker the same way shown in\nthis picture, then ask the experimenter to press space key')
	screen.alpha(1);	backpicture = viz.addTexture('wearglove.JPG');		screen.texture(backpicture)
	yield viztask.waitKeyDown(' ');		screen.alpha(0)

#	text.message('Please watch this short video, it lasts for 10 seconds')
#	screenformovie = viz.addTexQuad(pos=[0, -0.6, 0.1], scale = [1.2, 1, 1], euler = [0,70,0]);
#	backpictureformovie = viz.addTexture('whitecolor.JPG');	screenformovie.texture(backpictureformovie); 	
#	yield sendPulse(128);		yield viztask.waitTime( 2 );		
#	
#	movie = viz.addVideo('experiment2_0.avi');		screenformovie.texture(movie);	movie.play()
#	
#	yield viztask.waitTime( 10 )	;	screenformovie.alpha(0)	
#	text.message('video is finished, move to next step')
#	yield viztask.waitTime( 2 );		yield sendPulse(128);

def game_illusion(similarity,passiveoractive,synchronicity,driftnumberused_1,driftnumberused_2,blocknumber):
	####illusion - visual tactile part, in the illusion section, the hand is put palm downwards.
	
	if synchronicity == 0:
		import handkh as hand
	if synchronicity == 1:
		import hand_delay as hand
	
	text = text_dict[ 'instructions' ]
	text.message('Please rest your right hand with your palm downwards, \nand then ask experimenter to press space key')
#	screen = viz.addTexQuad(pos=[0, -0.6, 0.1], scale = [0.7, 1.1, 2], euler = [0,70,0]);			
	screen.alpha(1);	backpicture = viz.addTexture('palmdownwards.JPG');		screen.texture(backpicture)
	yield viztask.waitKeyDown(' ');		screen.alpha(0)
	
	####visual part
	if similarity == 0:			####this part is for virtual hand
		glove = hand.add(glovecyber,hand.CYBERGLOVE);								#		glove.visible(viz.OFF)
		glove.setPosition([0,0,-0.13]);				glove.setScale([2,2,2.2]);		
		
		if passiveoractive == 0:		####static virtual hand
			def Passivekeepgesture15():
				glove.setGesture(15)
			vibratetimer_Passivekeepgesture15 = vizact.ontimer(0, Passivekeepgesture15) 
			
			####proprioceptive drift measurement
			text.message(driftnumberused_1 + '\n\nPlease tell the experimenter where you feel your right\nmiddle finger is and wait for him to record the number.\nAfter that, ask him to press space key to continue.')
			yield viztask.waitKeyDown(' ');			screen.alpha(0);				text.message('')

			text.message('Please do NOT move your hand or fingers.\nLook at this hand through the screen')#,\nask experimenter to press space key to continue.')
#			yield viztask.waitKeyDown('r'); ####if it is passive, do not need 1 munite to freely move hand, so set the time as 2 seconds
			
			fadeIn = vizact.moveTo([0.2,0.08,0.11],time=2);				fadeOut = vizact.moveTo([0.02,0.005,0.11],time=2)
			syncvibrationdistance = 0.243;		asyncvibrationdistance_start = 0.30;		asyncvibrationdistance_end = 0.323
			
		if passiveoractive == 1:		####active virtual hand
		
			####proprioceptive drift measurement
			text.message(driftnumberused_1 + '\n\nPlease tell the experimenter where you feel your right\nmiddle finger is and wait for him to record the number.\nAfter that, ask him to press space key to continue.')
			yield viztask.waitKeyDown(' ');			screen.alpha(0);				text.message('')

			Data_delay_eul =  [[1]*3]*500;
			def gettrackereuler():
				yaw,pitch,roll = tracker.getEuler()
				raweuler = [yaw,pitch,roll]
				if (yaw >= 37):
					raweuler = [37,pitch,roll]
				if (yaw <= -37):
					raweuler = [-37,pitch,roll]
				if synchronicity == 0:
					glove.setEuler(raweuler)
				if synchronicity == 1:
					Data_delay_eul.append(raweuler)
					neweuler = Data_delay_eul.pop(0)
					glove.setEuler(neweuler)
			vibratetimer_gettrackereuler = vizact.ontimer(0, gettrackereuler)
			###############~~~~~~~~~~~~~~~~~~#################
#			def limittrackereuler():
#				yaw,pitch,roll = tracker.getEuler()
#				raweuler = [yaw,pitch,roll]
#				if (yaw >= 37):
#					neweuler = [37,pitch,roll]
#					glove.setEuler(neweuler) #
#				if (yaw <= -37):
#					neweuler = [-37,pitch,roll]
#					glove.setEuler(neweuler) #
#			vibratetimer_limittrackereuler = vizact.ontimer(0, limittrackereuler) 
		###############~~~~~~~~~~~~~~~~~~#################
	
			text.message('Please keep moving your hand and fingers freely\nuntil the next screen instruction appears.')
#			yield viztask.waitTime( 180*debugging ); #### make the freely movement 2 minute
			yield viztask.waitKeyDown(' ');
#			text.message('')

			fadeIn = vizact.moveTo([0.02,0.035,0.11],time=0.02);					fadeOut = vizact.moveTo([0.02,0.005,0.11],time=0.02)		
		object_roll_pos = [0.2,0.08,0.11];		object_roll_euler = [15,0,86];		object_roll_scale = [0.001,0.001,0.001];

	if similarity == 1:			####this part is for the virtual square
		glove_euler = [0,0,0];		glove = viz.add('art/panel.dae',pos=(0,0,-0.3),euler=glove_euler,scale=[sizeofx,sizeofy,sizeofz]);
		glove.color([0,1,0]);		glove.alpha(1);		#	 	glove.visible(viz.OFF)

		####proprioceptive drift measurement
		text.message(driftnumberused_1 + '\n\nPlease tell the experimenter where you feel your right\nmiddle finger is and wait for him to record the number.\nAfter that, ask him to press space key to continue.')
		yield viztask.waitKeyDown(' ');			screen.alpha(0);				text.message('')

		if passiveoractive == 0:
			text.message('Please do NOT move your hand or fingers.\nLook at this hand through the screen')#,\nask experimenter to press space key to continue.')
#			yield viztask.waitKeyDown('r'); ####if it is passive, do not need 1 munite to freely move hand, so set the time as 2 seconds
		
			object_roll_start = [120,80,110];	object_roll_des = [3,15,110];
			fadeIn = vizact.moveTo(object_roll_start,time=2);				fadeOut = vizact.moveTo(object_roll_des,time=2)
			syncvibrationdistance = 112;			asyncvibrationdistance_start = 173;		asyncvibrationdistance_end = 182
			
		if passiveoractive == 1:	
			glove2222 = viz.add('art/panel.dae',pos=(-0.1,0,-0.3),euler=glove_euler,scale=[sizeofx,sizeofy,sizeofz]);
			glove2222.alpha(0);		keepsizelink = viz.link(glove,glove2222);
			Data_delay_ges =  [[1]*21]*500;
			def getgloveGesture():
				cyberglovedata_raw = glovecyber.getData()
				if synchronicity == 0:
					raw1 = cyberglovedata_raw
				if synchronicity == 1:
					cyberglovedata_changed = cyberglovedata_raw
					cyberglovedata_changed[0:7] = cyberglovedata_raw[8:15]
					cyberglovedata_changed[8:15] = cyberglovedata_raw[0:7]
					Data_delay_ges.append(cyberglovedata_changed)
					raw1 = Data_delay_ges.pop(0)

				cyberdataflag = (raw1[3]+raw1[4]+raw1[6]+raw1[7]+raw1[9]+raw1[10]+raw1[12]+raw1[13])/8;

				if cyberdataflag <= -90:
					glove.addAction(colorpanel_action0) 
				if (cyberdataflag > -90) & (cyberdataflag <= -80):
					glove.addAction(colorpanel_action1)
				if (cyberdataflag > -80) & (cyberdataflag <= -70):
					glove.addAction(colorpanel_action2) 
				if (cyberdataflag > -70) & (cyberdataflag <= -60):
					glove.addAction(colorpanel_action3) 
				if (cyberdataflag > -60) & (cyberdataflag <= -50):
					glove.addAction(colorpanel_action4)
				if (cyberdataflag > -50) & (cyberdataflag <= -40):
					glove.addAction(colorpanel_action5)
				if (cyberdataflag > -40) & (cyberdataflag <= -30):
					glove.addAction(colorpanel_action6)
				if (cyberdataflag > -30) & (cyberdataflag <= -20):
					glove.addAction(colorpanel_action7)
				if (cyberdataflag > -20) & (cyberdataflag <= -10):
					glove.addAction(colorpanel_action8)	
				if (cyberdataflag > -10):
					glove.addAction(colorpanel_action9) 
			vibratetimer_getgloveGesture = vizact.ontimer(0, getgloveGesture) 
			
			Data_delay_eul =  [glove_euler]*500;
			def gettrackereuler():
				yaw,pitch,roll = tracker.getEuler()
				raweuler = [yaw,pitch,roll]
				if (yaw >= 37):
					raweuler = [37,pitch,roll]
				if (yaw <= -37):
					raweuler = [-37,pitch,roll]
				if synchronicity == 0:
					glove.setEuler(raweuler)
				if synchronicity == 1:
					Data_delay_eul.append(raweuler)
					neweuler = Data_delay_eul.pop(0)
					glove.setEuler(neweuler) #
			vibratetimer_gettrackereuler = vizact.ontimer(0, gettrackereuler) 

		###############~~~~~~~~~~~~~~~~~~#################
#			def limittrackereuler():
#				yaw,pitch,roll = tracker.getEuler()
#				raweuler = [yaw,pitch,roll]
#				if (yaw >= 37):
#					neweuler = [37,pitch,roll]
#					glove.setEuler(neweuler) #
#				if (yaw <= -37):
#					neweuler = [-37,pitch,roll]
#					glove.setEuler(neweuler) #
#			vibratetimer_limittrackereuler = vizact.ontimer(0, limittrackereuler) 
		###############~~~~~~~~~~~~~~~~~~#################

			text.message('Please keep moving your hand and fingers freely\nuntil the next screen appears.')
#			yield viztask.waitTime( 180*debugging ); #### make the freely movement 2 minute
			yield viztask.waitKeyDown(' ');
#			text.message('')
			
			object_roll_start = [0,25,110];	object_roll_des = [0,20,110];
			fadeIn = vizact.moveTo(object_roll_start,time=0.02);				fadeOut = vizact.moveTo(object_roll_des,time=0.02)
		object_roll_pos = object_roll_start;		object_roll_euler = [0,90,90];		object_roll_scale = [0.7,0.7,0.7];
		
	####tactile part
#	glove.visible(viz.OFF)#### send a pulse when the ball shows
#	if passiveoractive == 0:
#		text.message('Please put your hand as shown in the picture.\nDo Not move your right hand.\nAsk the experimenter to press space key to continue.')
#	if passiveoractive == 1:
#		text.message('Please put your hand as shown in the picture.\nPress space key to continue.\nYou can keep moving your right hand.')
##	screen = viz.addTexQuad(pos=[0, -0.6, 0.1], scale = [0.7, 1.2, 2], euler = [0,70,0]);			screen.alpha(1)
#	screen.alpha(1);	backpicture = viz.addTexture('palmdownwards.JPG');		screen.texture(backpicture)
#	yield viztask.waitKeyDown('r');		screen.alpha(0)
#	text.message('');		glove.visible(viz.ON);		
	yield sendPulse(128);

	if (similarity == 1) & (passiveoractive == 1): 
		object_roll = glove2222.add('art/panel_panel.dae',pos=object_roll_pos,euler=object_roll_euler,scale=object_roll_scale);		object_roll.color([0.6,0.6,0.6])
	else: 
		object_roll = glove.add('art/panel_panel.dae',pos=object_roll_pos,euler=object_roll_euler,scale=object_roll_scale);		object_roll.color([0.6,0.6,0.6])
		
	for number in range(100000):
	#	fadeInAndOut = vizact.sequence(fadeIn,fadeOut,viz.FOREVER)
		object_roll.addAction(fadeOut);		object_roll.addAction(fadeIn)
	
	def checkwhentostartglovevibration():
		if similarity == 0:			####this part is for virtual hand
			if passiveoractive == 1:
				data = glovecyber.getData()
				if 	synchronicity == 0:				####visual and tactile stimuli are synchronously received by participants
					if (data[3] > 00) & (data[4] > -30):
						glovecyber.setVibration( immersion.TOUCH_INDEX, 0.5 )
					if (data[6] > 00) & (data[7] > -30):
						glovecyber.setVibration( immersion.TOUCH_MIDDLE, 0.5 )
					if (data[9] > 0) & (data[10] > -30):
						glovecyber.setVibration( immersion.TOUCH_RING, 0.5 )	
					if (data[12] > 00) & (data[13] > -100):
						glovecyber.setVibration( immersion.TOUCH_PINKY, 0.5 )	
					else:
						glovecyber.clearVibration()
				if 	synchronicity == 1:				####visual and tactile stimuli are asynchronously received by participants
					if (data[3] < -30) & (data[4] < -40):
						glovecyber.setVibration( immersion.TOUCH_INDEX, 0.5 )
					if (data[6] < -10) & (data[7] < -10):
						glovecyber.setVibration( immersion.TOUCH_MIDDLE, 0.5 )
					if (data[9] > -0) & (data[10] > -40):
						glovecyber.setVibration( immersion.TOUCH_RING, 0.5 )	
					if (data[12] < -00) & (data[13] < -150):
						glovecyber.setVibration( immersion.TOUCH_PINKY, 0.5 )	
					else:
						glovecyber.clearVibration()
			if passiveoractive == 0:
				getobjectrollposition = object_roll.getPosition();					pos_glove_passive = glove.getPosition()
				checkdistance = vizmat.Distance(pos_glove_passive, getobjectrollposition)
#				print checkdistance
				if 	synchronicity == 0:				####visual and tactile stimuli are synchronously received by participants
					if ( checkdistance <  syncvibrationdistance ):
						glovecyber.setVibration( immersion.TOUCH_INDEX, 0.5 )
						glovecyber.setVibration( immersion.TOUCH_MIDDLE, 0.5 )
						glovecyber.setVibration( immersion.TOUCH_RING, 0.5 )
						glovecyber.setVibration( immersion.TOUCH_PINKY, 0.5 )
					else:
						glovecyber.clearVibration()
				if 	synchronicity == 1:				####visual and tactile stimuli are asynchronously received by participants
					if ( asyncvibrationdistance_start < checkdistance <  asyncvibrationdistance_end ) & (object_roll.getAction() == fadeIn):
						glovecyber.setVibration( immersion.TOUCH_INDEX, 0.5 )
						glovecyber.setVibration( immersion.TOUCH_MIDDLE, 0.5 )
						glovecyber.setVibration( immersion.TOUCH_RING, 0.5 )
						glovecyber.setVibration( immersion.TOUCH_PINKY, 0.5 )
					else:
						glovecyber.clearVibration()		
						
		if similarity == 1:			####this part is for virtual square
			if passiveoractive == 1:
				data = glovecyber.getData()
				if 	synchronicity == 0:				####visual and tactile stimuli are synchronously received by participants
					if (data[3] > 00) & (data[4] > -30):
						glovecyber.setVibration( immersion.TOUCH_INDEX, 0.5 )
					if (data[6] > 00) & (data[7] > -35):
						glovecyber.setVibration( immersion.TOUCH_MIDDLE, 0.5 )
					if (data[9] > 0) & (data[10] > -35):
						glovecyber.setVibration( immersion.TOUCH_RING, 0.5 )	
					if (data[12] > 00) & (data[13] > -100):
						glovecyber.setVibration( immersion.TOUCH_PINKY, 0.5 )	
					else:
						glovecyber.clearVibration()
				if 	synchronicity == 1:				####visual and tactile stimuli are asynchronously received by participants
					if (data[3] < -30) & (data[4] < -40):
						glovecyber.setVibration( immersion.TOUCH_INDEX, 0.5 )
					if (data[6] < -10) & (data[7] < -10):
						glovecyber.setVibration( immersion.TOUCH_MIDDLE, 0.5 )
					if (data[9] > -0) & (data[10] > -40):
						glovecyber.setVibration( immersion.TOUCH_RING, 0.5 )	
					if (data[12] < -00) & (data[13] < -150):
						glovecyber.setVibration( immersion.TOUCH_PINKY, 0.5 )	
					else:
						glovecyber.clearVibration()
						
			if passiveoractive == 0:
				getobjectrollposition = object_roll.getPosition();					pos_glove_passive = glove.getPosition()
				checkdistance = vizmat.Distance(pos_glove_passive, getobjectrollposition)
#				print checkdistance
				if 	synchronicity == 0:				####visual and tactile stimuli are synchronously received by participants
					if ( checkdistance <  syncvibrationdistance ):
						glovecyber.setVibration( immersion.TOUCH_INDEX, 0.5 )
						glovecyber.setVibration( immersion.TOUCH_MIDDLE, 0.5 )
						glovecyber.setVibration( immersion.TOUCH_RING, 0.5 )
						glovecyber.setVibration( immersion.TOUCH_PINKY, 0.5 )
					else:
						glovecyber.clearVibration()
				if 	synchronicity == 1:				####visual and tactile stimuli are asynchronously received by participants
					if ( asyncvibrationdistance_start <= checkdistance <  asyncvibrationdistance_end ) & (object_roll.getAction() == fadeIn):
						glovecyber.setVibration( immersion.TOUCH_INDEX, 0.5 )
						glovecyber.setVibration( immersion.TOUCH_MIDDLE, 0.5 )
						glovecyber.setVibration( immersion.TOUCH_RING, 0.5 )
						glovecyber.setVibration( immersion.TOUCH_PINKY, 0.5 )
					else:
						glovecyber.clearVibration()		
	vibratetimer_roll_action = vizact.ontimer(0, checkwhentostartglovevibration)
	
#	yield viztask.waitTime( 180 *debugging )
	yield viztask.waitKeyDown(' ');
	vibratetimer_roll_action.setEnabled(viz.OFF)
	object_roll.clearActions();		glovecyber.clearVibration();		object_roll.visible(viz.OFF);	
		
#	if (similarity == 1) & (passiveoractive == 1):
#		vibratetimer_getgloveGesture.setEnabled(viz.OFF)
#		vibratetimer_gettrackereuler.setEnabled(viz.OFF)					####shut down the timers
#		keepsizelink.setEnabled(viz.OFF)
#	if (similarity == 0) & (passiveoractive == 1):
#		vibratetimer_gettrackereuler.setEnabled(viz.OFF)					####shut down the timers
#	if (similarity == 0) & (passiveoractive == 0):
#		vibratetimer_Passivekeepgesture15.setEnabled(viz.OFF)
	yield sendPulse(128);			#### send a pulse when the tactile part ends
	glove.visible(viz.OFF);

########################~~~~~~~~~~~~~~measure SCR~~~~~~~~~~~~~~#######################
#	if passiveoractive == 1:
	text.message('Please rest your right hand with your palm downwards, \nlike this picture shows,\nand from now on, do NOT move your hand or fingers.')
	screen.alpha(1);
	backpicture = viz.addTexture('palmdownwards.JPG');		screen.texture(backpicture);
#	yield viztask.waitTime( 10 )
	yield viztask.waitKeyDown(' ');
	screen.alpha(0);
	text.message('');			glove.visible(viz.ON);
	
	#### adding the knife movement, add knife, do not add knife blood, delete the blood effect	
	if (similarity == 1) & (passiveoractive == 1): 
		object_knife = glove2222.add('knifes\sharpknife.dae');
	else:
		object_knife = glove.add('knifes\sharpknife.dae');
		
	pos_glove = glove.getPosition()				#### adding the knife movement

	if similarity == 0:
		object_knife.setScale([0.03,0.03,0.03]);			object_knife.setEuler([10,20,0]);
		pos_object_knife_start = [pos_glove[0]+0.1,pos_glove[1]+0.2, pos_glove[2]+0.22];		
		pos_object_knife_des = [pos_glove[0]+0.1,pos_glove[1]-0.01, pos_glove[2]+0.22]
		syncvibrationdistance = 0.242;
	if similarity == 1:
		object_knife.setScale([23,23,23]);					object_knife.setEuler([10,20,0]);
		pos_object_knife_start = [pos_glove[0]+55,pos_glove[1]+150, pos_glove[2]+100];		
		pos_object_knife_des = [pos_glove[0]+55,pos_glove[1]-0, pos_glove[2]+100]
		syncvibrationdistance = 117;
	
	object_knife.setPosition(pos_object_knife_start);																			
	object_knife_action1 = vizact.moveTo(pos_object_knife_des, time = 4);										
	object_knife_action2 = vizact.moveTo(pos_object_knife_start, time = 4)
	cuttingtimes = 5
	
#	viz.window.startRecording('experiment2_0.avi')
	for number in range(cuttingtimes):
		yield sendPulse(64) 										####send a marker here, start a block SCR meansurement when the knife just appear
		object_knife.addAction(object_knife_action1);				object_knife.addAction(object_knife_action2)

		def checkwhentostartglovevibration():
			getobjectknifeposition = object_knife.getPosition();						pos_glove = glove.getPosition()
			checkdistance = vizmat.Distance(pos_glove, getobjectknifeposition)
#			print checkdistance
			####in the measurement part, only visual-tactile sync or only visual
			if (similarity == 0) & (checkdistance <  syncvibrationdistance): #& (object_knife.getAction() == object_knife_action2)  :
				glovecyber.setVibration( immersion.TOUCH_INDEX, 0.5 )
				glovecyber.setVibration( immersion.TOUCH_MIDDLE, 0.5 )
				glovecyber.setVibration( immersion.TOUCH_RING, 0.5 )
				glovecyber.setVibration( immersion.TOUCH_PINKY, 0.5 )
			if (similarity == 1) & (checkdistance <  syncvibrationdistance):#
				glovecyber.setVibration( immersion.TOUCH_INDEX, 0.5 )
				glovecyber.setVibration( immersion.TOUCH_MIDDLE, 0.5 )
				glovecyber.setVibration( immersion.TOUCH_RING, 0.5 )
				glovecyber.setVibration( immersion.TOUCH_PINKY, 0.5 )
			else:
				glovecyber.clearVibration()
		vibratetimer_knife_action = vizact.ontimer(0, checkwhentostartglovevibration)

		yield viztask.waitActionEnd(object_knife,object_knife_action2)
		vibratetimer_knife_action.setEnabled(viz.OFF)
		object_knife.clearActions();			glovecyber.clearVibration();
		yield viztask.waitTime(4);					####4 + 4 + 4 = 12s * 5 = 1minute
	object_knife.visible(viz.OFF);			object_knife.alpha(0)
#	viz.window.stopRecording()  

	if (passiveoractive == 1) & (similarity == 1):
		vibratetimer_getgloveGesture.setEnabled(viz.OFF)
		vibratetimer_gettrackereuler.setEnabled(viz.OFF)				####shut down the action timers
		keepsizelink.setEnabled(viz.OFF)
#		vibratetimer_limittrackereuler.setEnabled(viz.OFF)
	if (passiveoractive == 0) & (similarity == 0):
		vibratetimer_Passivekeepgesture15.setEnabled(viz.OFF)		
	if (similarity == 0) & (passiveoractive == 1):
		vibratetimer_gettrackereuler.setEnabled(viz.OFF)					####shut down the timers
#		vibratetimer_limittrackereuler.setEnabled(viz.OFF)
	
	yield sendPulse(64) ####send a marker here, start a block scr meansurement
	
	####proprioceptive drift measurement
	text.message(driftnumberused_2 + '\n\nPlease tell the experimenter where you feel your right\nmiddle finger is and wait for him to record the number.\nAfter that, ask him to press space key to continue.')
	yield viztask.waitKeyDown(' ');			screen.alpha(0);				text.message('')
	glove.visible(viz.OFF);
	
	if (similarity == 1) & (passiveoractive == 1):
		text.message('You just experienced two sections:\n1. the gray stick touch section and \n2. the knife cut section.\n\nA 14-questions questionnaire will appear,\nit is about 1. the gray stick touch section' + '\n\n' + 'please answer it \npress space key to continue.\n')
	else:
		text.message('You just experienced two sections:\n1. the gray stick touch section and \n2. the knife cut section.\n\nA 13-questions questionnaire will appear,\nit is about 1. the gray stick touch section' + '\n\n' + 'please answer it \npress space key to continue.\n')

	yield viztask.waitKeyDown(' ');				text.message('');

def showquestion(question, qnumber):
	file = open('response ' + str(subjectnumber)+ '.txt', 'a')
	text = text_dict[ 'instructions' ]
	text.message(question)
	def SaveData(key):
		global out
		out = key + '\t'
	viz.callback(viz.KEYBOARD_EVENT, SaveData)		#### Creating the call-back	
	yield viztask.waitAny( [ viztask.waitKeyDown('1'),viztask.waitKeyDown('2'),viztask.waitKeyDown('3'),viztask.waitKeyDown('4'),viztask.waitKeyDown('5'),viztask.waitKeyDown('6'),viztask.waitKeyDown('7')])		#### Wating for valid key-press, before skipping to next question
	viz.callback(viz.KEYBOARD_EVENT, None)			#### Deleting the call-back
	
def questionnaire(similarity,passiveoractive,synchronicity,blocknumber):
	file = open('response ' + str(subjectnumber)+ '.txt', 'a')			#### Opening the log-file
	file.write(str(subjectnumber) + '\t' + str(similarity) + '\t' + str(passiveoractive) + '\t' + str(synchronicity) + '\t')		#### Adding subjectnumber at beginning of line PP\tsimilarity\tpassiveoractive\tsync\
	#	random.shuffle(questions4object)		####why we do not use 'shuffle'? because it is difficult to record the sequence and sort the right rank for the right question
	
	if (similarity == 0) & (passiveoractive == 0) & (synchronicity == 0):		##hand passive synchronous
		questionnaireused = questions4hand_condition1
	if (similarity == 0) & (passiveoractive == 0) & (synchronicity == 1):		##hand passive asynchronous
		questionnaireused = questions4hand_condition2
	if (similarity == 0) & (passiveoractive == 1) & (synchronicity == 0):		##hand active synchronous
		questionnaireused = questions4hand_condition3
	if (similarity == 0) & (passiveoractive == 1) & (synchronicity == 1):		##hand active asynchronous
		questionnaireused = questions4hand_condition4
	if (similarity == 1) & (passiveoractive == 0) & (synchronicity == 0):		##square passive synchronous
		questionnaireused = questions4hand_condition5
	if (similarity == 1) & (passiveoractive == 0) & (synchronicity == 1):		##square passive asynchronous
		questionnaireused = questions4hand_condition6
	if (similarity == 1) & (passiveoractive == 1) & (synchronicity == 0):		##square active synchronous
		questionnaireused = questions4hand_condition7
	if (similarity == 1) & (passiveoractive == 1) & (synchronicity == 1):		##square active asynchronous
		questionnaireused = questions4hand_condition8	

	questions = questionnaireused
	for qnumber, question in enumerate(questions):
		yield showquestion('Question ' + str(qnumber+1) + ': ' + question + '\n' +qinstructions, qnumber+1)			#### Running through the questions and adding the pressed key to the log-file
		file.write(out)						#### Adding the line break at the end of the block
	file.write('\n')
	file.close()
	text.message('You have finished filling the questionnaire.\n\nYou have finished ' + str(blocknumber) + ' of ' + str(totalblocknumber) + ' blocks.' + '\n' + 'You can ask the experimenter' + '\n' + 'to press the space key to continue')
	yield viztask.waitKeyDown(' ');		text.message('');
	
def quit():
	text = text_dict[ 'instructions' ]
	text.message( 'The experiment is finished, thank you.' )
	yield viztask.waitTime( 2 )
	viz.quit()

########################### main_sequence ######################################
def main_sequence():
#	yield instructions()
	blocknumber = 0
	for similarity in similaritys:
		for passiveoractive in passiveoractives:
			for synchronicity in synchronicitys:
				blocknumber = blocknumber+1				
				yield game_illusion(similarity,passiveoractive,synchronicity,driftnumberused_1,driftnumberused_2,blocknumber)
				yield questionnaire(similarity,passiveoractive,synchronicity,blocknumber)
	yield quit()
viztask.schedule( main_sequence() )

viz.MainView.setEuler(0,70,0);				#viz.MainView.setPosition(0,0.3,-0.1)
cam = vizcam.PivotNavigate()
cam.setCenter(0,0.012,0)
cam.setDistance(0.6)

